<?php
session_start();
header('Content-Type: application/json');

// Incluir configuración de la base de datos
require_once dirname(__FILE__) . '/../config.php';
require_once dirname(__FILE__) . '/../conexion.php';

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    $curso = $input['curso'] ?? null;
    $unidad = $input['unidad'] ?? null;
    $actividad = $input['actividad'] ?? null;

    // Validaciones básicas
    if (!$curso || !$unidad || !$actividad) {
        $response['message'] = 'Parámetros incompletos.';
        echo json_encode($response);
        exit;
    }

    // Normalizar formato de unidad
    $unidad_normalizada = '';
    if (preg_match('/Unidad (\d+)/', $unidad, $matches)) {
        // Si viene como "Unidad 01"
        $unidad_normalizada = str_pad($matches[1], 2, '0', STR_PAD_LEFT);
    } else {
        // Si ya viene como "01" o similar
        $unidad_normalizada = str_pad($unidad, 2, '0', STR_PAD_LEFT);
    }

    // Asegurarse de que la actividad sea número de dos dígitos
    $actividad_padded = str_pad($actividad, 2, '0', STR_PAD_LEFT);

    $table_name = "avance_{$curso}_u{$unidad_normalizada}";
    $column_name = "NIVACT{$actividad_padded}";

    try {
        // Verificar si la tabla existe
        $stmt = $dsn->prepare("SHOW TABLES LIKE :table_name");
        $stmt->execute([':table_name' => $table_name]);
        $table_exists = $stmt->fetch() !== false;

        if (!$table_exists) {
            $response['message'] = "La tabla '{$table_name}' no existe.";
            echo json_encode($response);
            exit;
        }

        // Verificar si la columna existe
        $stmt_check_col = $dsn->prepare("SHOW COLUMNS FROM `{$table_name}` LIKE :col_name");
        $stmt_check_col->execute([':col_name' => $column_name]);
        $col_exists = $stmt_check_col->fetch() !== false;

        if (!$col_exists) {
            $response['message'] = "La columna '{$column_name}' no existe en la tabla '{$table_name}'.";
            echo json_encode($response);
            exit;
        }

        // Actualizar el comentario de la columna
        $update_comment_sql = "ALTER TABLE `{$table_name}` MODIFY COLUMN `{$column_name}` INT(1) DEFAULT 0 COMMENT 'Nivel actual del estudiante en la ruta (0=Inicial, 1=Intermedio, 2=Avanzado, 3=Experto)'";
        $dsn->exec($update_comment_sql);

        $response['success'] = true;
        $response['message'] = "✅ Comentario de la columna '{$column_name}' actualizado correctamente.";

    } catch (PDOException $e) {
        $response['message'] = "Error de base de datos: " . $e->getMessage();
        error_log("Error en actualizar_comentario_nivact.php: " . $e->getMessage());
    } catch (Exception $e) {
        $response['message'] = "Error inesperado: " . $e->getMessage();
        error_log("Error inesperado en actualizar_comentario_nivact.php: " . $e->getMessage());
    }
} else {
    $response['message'] = 'Método no permitido.';
}

echo json_encode($response);
?>
