<?php
// Deshabilitar display de errores para evitar HTML en la respuesta JSON
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Iniciar sesión y establecer header JSON
session_start();
header('Content-Type: application/json');

// Incluir configuración de la base de datos
require_once dirname(__FILE__) . '/../config.php';
require_once dirname(__FILE__) . '/../conexion.php';

$response = ['success' => false, 'message' => '', 'data' => []];

// Log para debugging
error_log("API cargar_respuesta_larga.php - Iniciando procesamiento");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    // Log de datos recibidos
    error_log("Datos recibidos para carga: " . json_encode($input));

    $numero_respuesta = $input['numero_respuesta'] ?? null;
    $curso = $input['curso'] ?? null;
    $unidad = $input['unidad'] ?? null;
    $actividad = $input['actividad'] ?? null;

    // Validaciones básicas
    if (!$numero_respuesta || !$curso || !$unidad || !$actividad) {
        $response['message'] = 'Parámetros incompletos para cargar datos.';
        error_log("Error: Parámetros incompletos - numero: $numero_respuesta, curso: $curso, unidad: $unidad, actividad: $actividad");
        echo json_encode($response);
        exit;
    }
    
    error_log("Parámetros validados correctamente para carga");

    // Normalizar formato de unidad (Unidad 01 -> 01)
    $unidad_normalizada = '';
    if (preg_match('/Unidad (\d+)/', $unidad, $matches)) {
        $unidad_normalizada = str_pad($matches[1], 2, '0', STR_PAD_LEFT);
    }

    // Asegurarse de que la actividad sea un número de dos dígitos
    $actividad_padded = str_pad($actividad, 2, '0', STR_PAD_LEFT);
    $numero_respuesta_padded = str_pad($numero_respuesta, 2, '0', STR_PAD_LEFT);

    $table_name = "avance_{$curso}_u{$unidad_normalizada}";
    
    // Nombres de las columnas
    $columna_respuesta = "RL{$numero_respuesta_padded}ACT{$actividad_padded}";
    $columna_retroalimentacion = "RTRL{$numero_respuesta_padded}ACT{$actividad_padded}";
    $columna_nota = "NTRL{$numero_respuesta_padded}ACT{$actividad_padded}";
    $columna_fecha_respuesta = "FRL{$numero_respuesta_padded}ACT{$actividad_padded}";
    $columna_fecha_retroalimentacion = "FRTRL{$numero_respuesta_padded}ACT{$actividad_padded}";
    $columna_fecha_nota = "FNTRL{$numero_respuesta_padded}ACT{$actividad_padded}";
    $columna_palabras = "PRL{$numero_respuesta_padded}ACT{$actividad_padded}";
    $columna_fecha_limite = "FLRL{$numero_respuesta_padded}ACT{$actividad_padded}";
    
    try {
        // Verificar si la tabla existe
        $check_table = $dsn->query("SHOW TABLES LIKE '$table_name'");
        if ($check_table->rowCount() === 0) {
            $response['message'] = "La tabla $table_name no existe aún.";
            error_log("Tabla $table_name no existe");
            echo json_encode($response);
            exit;
        }
        
        // Verificar si las columnas existen
        $check_columns = $dsn->query("SHOW COLUMNS FROM $table_name LIKE '$columna_respuesta%'");
        if ($check_columns->rowCount() === 0) {
            $response['message'] = "Las columnas para Respuesta Larga no existen aún.";
            error_log("Columnas para RL no existen en tabla $table_name");
            echo json_encode($response);
            exit;
        }
        
        // Obtener el ID del usuario actual (asumiendo que hay una sesión activa)
        $user_id = $_SESSION['user_id'] ?? 1; // Fallback a ID 1 si no hay sesión
        
        error_log("User ID para carga: $user_id (sesión: " . (isset($_SESSION['user_id']) ? 'activa' : 'no activa') . ")");
        
        // Consultar los datos existentes
        $sql = "SELECT 
                    $columna_respuesta as respuesta,
                    $columna_retroalimentacion as retroalimentacion,
                    $columna_nota as nota,
                    $columna_fecha_respuesta as fecha_respuesta,
                    $columna_fecha_retroalimentacion as fecha_retroalimentacion,
                    $columna_fecha_nota as fecha_nota,
                    $columna_palabras as palabras,
                    $columna_fecha_limite as fecha_limite
                FROM $table_name 
                WHERE id = ?";
        
        error_log("Ejecutando consulta: $sql con user_id: $user_id");
        
        $stmt = $dsn->prepare($sql);
        $stmt->execute([$user_id]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($result) {
            $row = $result;
            
            $response['success'] = true;
            $response['message'] = 'Datos cargados exitosamente';
            $response['data'] = [
                'respuesta' => $row['respuesta'] ?? '',
                'retroalimentacion' => $row['retroalimentacion'] ?? '',
                'nota' => $row['nota'] ?? '',
                'fecha_respuesta' => $row['fecha_respuesta'] ?? null,
                'fecha_retroalimentacion' => $row['fecha_retroalimentacion'] ?? null,
                'fecha_nota' => $row['fecha_nota'] ?? null,
                'palabras' => $row['palabras'] ?? null,
                'fecha_limite' => $row['fecha_limite'] ?? null
            ];
            
            error_log("Datos cargados: " . json_encode($response['data']));
        } else {
            // No hay datos para este usuario, devolver campos vacíos
            $response['success'] = true;
            $response['message'] = 'No hay datos guardados para este usuario';
            $response['data'] = [
                'respuesta' => '',
                'retroalimentacion' => '',
                'nota' => '',
                'fecha_respuesta' => null,
                'fecha_retroalimentacion' => null,
                'fecha_nota' => null,
                'palabras' => null,
                'fecha_limite' => null
            ];
            
            error_log("No hay datos para user_id: $user_id");
        }
        
    } catch (Exception $e) {
        error_log("Error en cargar_respuesta_larga.php: " . $e->getMessage());
        $response['message'] = 'Error al cargar datos: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Método no permitido';
}

echo json_encode($response);
?>
