<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Manejar preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

// No necesitamos conexión a BD para crear archivos

try {
    // Verificar que la petición sea POST
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Método no permitido');
    }

    // Obtener datos del POST
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        throw new Exception('Datos inválidos');
    }

    $curso = $input['curso'] ?? '';
    $unidad = $input['unidad'] ?? '';
    $actividad = $input['actividad'] ?? '';

    // Validar parámetros
    if (empty($curso) || empty($unidad) || empty($actividad)) {
        throw new Exception('Parámetros requeridos: curso, unidad, actividad');
    }

    // Validar formato de curso (ej: c001)
    if (!preg_match('/^c\d{3}$/', $curso)) {
        throw new Exception('Formato de curso inválido');
    }

    // Validar formato de unidad (ej: 01)
    if (!preg_match('/^\d{2}$/', $unidad)) {
        throw new Exception('Formato de unidad inválido');
    }

    // Validar formato de actividad (ej: 1, 2, 3...)
    if (!is_numeric($actividad) || $actividad < 1) {
        throw new Exception('Formato de actividad inválido');
    }

    // Formatear número de actividad con 2 dígitos
    $actividadFormateada = sprintf('%02d', $actividad);

    // Nombre del archivo
    $nombreArchivo = "{$curso}_u{$unidad}_act{$actividadFormateada}.php";
    $rutaCompleta = "../recursos/{$nombreArchivo}";

    // Crear directorio recursos si no existe
    $directorioRecursos = '../recursos';
    if (!is_dir($directorioRecursos)) {
        if (!mkdir($directorioRecursos, 0755, true)) {
            throw new Exception('No se pudo crear el directorio recursos');
        }
    }

    // Verificar si el archivo ya existe
    if (file_exists($rutaCompleta)) {
        throw new Exception('El archivo ya existe');
    }

    // Contenido en blanco del archivo de actividad
    $contenidoBasico = '<?php
// Archivo de actividad creado automáticamente
// Curso: ' . $curso . '
// Unidad: ' . $unidad . '
// Actividad: ' . $actividad . '

// Aquí puedes agregar el contenido de la actividad
';

    // Crear el archivo
    if (file_put_contents($rutaCompleta, $contenidoBasico) === false) {
        throw new Exception('No se pudo crear el archivo');
    }

    // Respuesta exitosa
    $response = [
        'success' => true,
        'message' => "Archivo {$nombreArchivo} creado exitosamente",
        'archivo' => $nombreArchivo,
        'ruta' => $rutaCompleta
    ];
    
    // Log para debug
    error_log("API Response: " . json_encode($response));
    
    echo json_encode($response);

} catch (Exception $e) {
    http_response_code(400);
    $errorResponse = [
        'success' => false,
        'message' => $e->getMessage()
    ];
    
    // Log para debug
    error_log("API Error: " . json_encode($errorResponse));
    
    echo json_encode($errorResponse);
}
?>
