<?php
session_start();
header('Content-Type: application/json');

$response = ['success' => false, 'message' => '', 'details' => []];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    $ruta_nombre = $input['ruta_nombre'] ?? null;
    $nivel_carpeta = $input['nivel_carpeta'] ?? null;
    $numero_item = $input['numero_item'] ?? null;
    $enunciado = $input['enunciado'] ?? '';
    $alternativas = $input['alternativas'] ?? [];
    $respuesta_correcta = $input['respuesta_correcta'] ?? '';
    $puntos = $input['puntos'] ?? 5;
    $retroalimentacion_correcta = $input['retroalimentacion_correcta'] ?? '';
    $retroalimentacion_incorrecta = $input['retroalimentacion_incorrecta'] ?? '';

    // Validaciones básicas
    if (!$ruta_nombre || !$nivel_carpeta || !$numero_item) {
        $response['message'] = 'Parámetros incompletos.';
        echo json_encode($response);
        exit;
    }

    if (empty($enunciado)) {
        $response['message'] = 'El enunciado es requerido.';
        echo json_encode($response);
        exit;
    }

    if (count($alternativas) < 2) {
        $response['message'] = 'Debe haber al menos 2 alternativas.';
        echo json_encode($response);
        exit;
    }

    if (empty($respuesta_correcta)) {
        $response['message'] = 'Debe seleccionar una respuesta correcta.';
        echo json_encode($response);
        exit;
    }

    // Construir ruta del archivo
    $ruta_carpeta = "../rutas/{$ruta_nombre}/{$nivel_carpeta}";
    $numero_padded = str_pad($numero_item, 2, '0', STR_PAD_LEFT);
    $archivo_item = "{$ruta_carpeta}/item{$numero_padded}.html";
    
    // Crear directorio si no existe
    if (!is_dir($ruta_carpeta)) {
        if (!mkdir($ruta_carpeta, 0755, true)) {
            $response['message'] = "No se pudo crear el directorio '{$nivel_carpeta}'.";
            echo json_encode($response);
            exit;
        }
    }

    try {
        // Generar HTML del item
        $html_content = generarHTMLItem($enunciado, $alternativas, $respuesta_correcta, $puntos, $retroalimentacion_correcta, $retroalimentacion_incorrecta);
        
        // Guardar archivo
        if (file_put_contents($archivo_item, $html_content) === false) {
            $response['message'] = "Error al guardar el archivo del item.";
            echo json_encode($response);
            exit;
        }

        $response['success'] = true;
        $response['message'] = "✅ Item {$numero_item} guardado exitosamente en {$nivel_carpeta}";
        $response['details']['archivo'] = $archivo_item;
        $response['details']['ruta_carpeta'] = $ruta_carpeta;

    } catch (Exception $e) {
        $response['message'] = "Error al guardar el item: " . $e->getMessage();
        error_log("Error en guardar_item.php: " . $e->getMessage());
    }
} else {
    $response['message'] = 'Método no permitido.';
}

echo json_encode($response);

function generarHTMLItem($enunciado, $alternativas, $respuesta_correcta, $puntos, $retroalimentacion_correcta, $retroalimentacion_incorrecta) {
    $alternativas_html = '';
    $letras = ['a', 'b', 'c', 'd', 'e', 'f'];
    
    foreach ($alternativas as $index => $alt) {
        $letra = $letras[$index] ?? chr(97 + $index);
        $alternativas_html .= "            <div class=\"exercise-option\" data-value=\"{$letra}\">\n";
        $alternativas_html .= "                {$alt}\n";
        $alternativas_html .= "            </div>\n";
    }
    
    return "<!DOCTYPE html>
<html lang=\"es\">
<head>
    <meta charset=\"UTF-8\">
    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">
    <script src=\"https://polyfill.io/v3/polyfill.min.js?features=es6\"></script>
    <link rel=\"stylesheet\" href=\"../item.css\">
    <script id=\"MathJax-script\" async src=\"https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js\"></script>
    <script>
        window.MathJax = {
            tex: {
                inlineMath: [['$', '$'], ['\\\\(', '\\\\)']],
                displayMath: [['$$', '$$'], ['\\\\[', '\\\\]']]
            }
        };
    </script>
</head>
<body>
    <div class=\"exercise-container\">
        <div class=\"exercise-question\">
            {$enunciado}
        </div>
        
        <div class=\"exercise-options\">
{$alternativas_html}        </div>
        
        <div class=\"exercise-feedback correct-feedback\">
            ✅ {$retroalimentacion_correcta}
        </div>
        <div class=\"exercise-feedback incorrect-feedback\">
            ❌ {$retroalimentacion_incorrecta}
        </div>
        
        <button class=\"btn-submit\" onclick=\"checkAnswer('{$respuesta_correcta}', {$puntos})\">Verificar Respuesta</button>
    </div>

    <script src=\"../item.js\"></script>
</body>
</html>";
}
?>
