<?php
session_start();
header('Content-Type: application/json');

$response = ['success' => false, 'message' => '', 'items' => []];

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $ruta_nombre = $_GET['ruta_nombre'] ?? null;
    $nivel_carpeta = $_GET['nivel_carpeta'] ?? null;

    // Validaciones básicas
    if (!$ruta_nombre || !$nivel_carpeta) {
        $response['message'] = 'Parámetros incompletos.';
        echo json_encode($response);
        exit;
    }

    // Construir ruta de la carpeta
    $ruta_carpeta = "../rutas/{$ruta_nombre}/{$nivel_carpeta}";
    
    if (!is_dir($ruta_carpeta)) {
        $response['message'] = "La carpeta del nivel '{$nivel_carpeta}' no existe.";
        echo json_encode($response);
        exit;
    }

    try {
        // Buscar archivos item*.html
        $items = [];
        $archivos = glob($ruta_carpeta . "/item*.html");
        
        foreach ($archivos as $archivo) {
            $nombre_archivo = basename($archivo);
            
            // Extraer número del item (item01.html -> 01)
            if (preg_match('/item(\d+)\.html/', $nombre_archivo, $matches)) {
                $numero_item = $matches[1];
                
                // Leer contenido del archivo para extraer información
                $contenido = file_get_contents($archivo);
                
                // Extraer enunciado (primer párrafo dentro de exercise-question)
                $enunciado = '';
                if (preg_match('/<div class="exercise-question">(.*?)<\/div>/s', $contenido, $matches)) {
                    $enunciado = strip_tags($matches[1]);
                    $enunciado = html_entity_decode($enunciado);
                    $enunciado = trim($enunciado);
                }
                
                // Extraer alternativas
                $alternativas = [];
                if (preg_match_all('/<div class="exercise-option"[^>]*data-value="([^"]*)"[^>]*>(.*?)<\/div>/s', $contenido, $matches, PREG_SET_ORDER)) {
                    foreach ($matches as $match) {
                        $valor = $match[1];
                        $texto = strip_tags($match[2]);
                        $texto = html_entity_decode($texto);
                        $texto = trim($texto);
                        
                        // Remover prefijo de letra si existe (A), B), C), etc.)
                        $texto = preg_replace('/^[A-Z]\)\s*/', '', $texto);
                        
                        $alternativas[] = ['valor' => $valor, 'texto' => $texto];
                    }
                }
                
                // Extraer retroalimentación correcta
                $retroalimentacion_correcta = '';
                if (preg_match('/<div class="exercise-feedback correct-feedback">(.*?)<\/div>/s', $contenido, $matches)) {
                    $retroalimentacion_correcta = strip_tags($matches[1]);
                    $retroalimentacion_correcta = html_entity_decode($retroalimentacion_correcta);
                    $retroalimentacion_correcta = trim($retroalimentacion_correcta);
                }
                
                // Extraer retroalimentación incorrecta
                $retroalimentacion_incorrecta = '';
                if (preg_match('/<div class="exercise-feedback incorrect-feedback">(.*?)<\/div>/s', $contenido, $matches)) {
                    $retroalimentacion_incorrecta = strip_tags($matches[1]);
                    $retroalimentacion_incorrecta = html_entity_decode($retroalimentacion_incorrecta);
                    $retroalimentacion_incorrecta = trim($retroalimentacion_incorrecta);
                }
                
                // Determinar respuesta correcta y puntos (del botón onclick)
                $respuesta_correcta = '';
                $puntos = 5; // Valor por defecto
                if (preg_match('/onclick="checkAnswer\(\'([^\']*)\',\s*(\d+)\)"/', $contenido, $matches)) {
                    $respuesta_correcta = $matches[1];
                    $puntos = intval($matches[2]);
                }
                
                $items[] = [
                    'numero' => $numero_item,
                    'archivo' => $nombre_archivo,
                    'enunciado' => $enunciado,
                    'alternativas' => $alternativas,
                    'respuesta_correcta' => $respuesta_correcta,
                    'puntos' => $puntos,
                    'retroalimentacion_correcta' => $retroalimentacion_correcta,
                    'retroalimentacion_incorrecta' => $retroalimentacion_incorrecta
                ];
            }
        }
        
        // Ordenar por número de item
        usort($items, function($a, $b) {
            return intval($a['numero']) - intval($b['numero']);
        });
        
        $response['success'] = true;
        $response['items'] = $items;
        $response['message'] = "Se encontraron " . count($items) . " items en el nivel '{$nivel_carpeta}'";
        
    } catch (Exception $e) {
        $response['message'] = "Error al leer los items: " . $e->getMessage();
        error_log("Error en listar_items_nivel.php: " . $e->getMessage());
    }
} else {
    $response['message'] = 'Método no permitido.';
}

echo json_encode($response);
?>
