<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Content-Type');

try {
    // Verificar que sea una petición GET
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
        throw new Exception('Método no permitido');
    }

    $ruta_nombre = $_GET['ruta_nombre'] ?? '';

    if (empty($ruta_nombre)) {
        throw new Exception('Nombre de ruta requerido');
    }

    // Ruta al archivo de configuración
    $config_path = "../rutas/{$ruta_nombre}/config.json";
    
    if (!file_exists($config_path)) {
        throw new Exception('Archivo de configuración no encontrado');
    }

    // Leer archivo de configuración
    $json_content = file_get_contents($config_path);
    if ($json_content === false) {
        throw new Exception('Error al leer archivo de configuración');
    }

    $config_data = json_decode($json_content, true);
    if (!$config_data) {
        throw new Exception('Error al decodificar archivo de configuración');
    }

    echo json_encode([
        'success' => true,
        'ruta_nombre' => $ruta_nombre,
        'niveles' => $config_data['niveles'] ?? [],
        'fecha_actualizacion' => $config_data['fecha_actualizacion'] ?? null,
        'version' => $config_data['version'] ?? '1.0'
    ]);

} catch (Exception $e) {
    error_log("Error en obtener_configuracion_niveles.php: " . $e->getMessage());
    
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
