<?php
// Archivo para manejar la subida de archivos multimedia (PDF, Video, Audio)
session_start();

// Verificar que sea una petición POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido']);
    exit;
}

// Obtener parámetros
$curso = isset($_POST['curso']) ? $_POST['curso'] : '';
$unidad = isset($_POST['unidad']) ? $_POST['unidad'] : '';
$actividad = isset($_POST['actividad']) ? $_POST['actividad'] : '';
$tipoSeccion = isset($_POST['tipo_seccion']) ? $_POST['tipo_seccion'] : 'pdf'; // pdf, video, podcast

// Verificar que se haya subido un archivo
if (!isset($_FILES['archivo']) || $_FILES['archivo']['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['success' => false, 'message' => 'No se ha subido ningún archivo']);
    exit;
}

$archivo = $_FILES['archivo'];

// Configurar tipos de archivo permitidos y directorios según el tipo
$tipoArchivo = mime_content_type($archivo['tmp_name']);
$extension = strtolower(pathinfo($archivo['name'], PATHINFO_EXTENSION));

switch ($tipoSeccion) {
    case 'video':
    case 'seccion-video':
        $tiposPermitidos = ['video/mp4', 'video/avi', 'video/quicktime', 'video/x-msvideo', 'video/webm'];
        $extensionesPermitidas = ['mp4', 'avi', 'mov', 'wmv', 'webm'];
        $directorio = '../videos/';
        $carpetaPublica = 'videos/';
        $mensajeError = 'Solo se permiten archivos de video (MP4, AVI, MOV, WMV, WEBM)';
        break;
        
    case 'podcast':
    case 'seccion-podcast':
        $tiposPermitidos = ['audio/mpeg', 'audio/mp3', 'audio/wav', 'audio/ogg'];
        $extensionesPermitidas = ['mp3', 'wav', 'ogg'];
        $directorio = '../podcasts/';
        $carpetaPublica = 'podcasts/';
        $mensajeError = 'Solo se permiten archivos de audio (MP3, WAV, OGG)';
        break;
        
    case 'pdf':
    case 'archivos-pdf':
    default:
        $tiposPermitidos = ['application/pdf'];
        $extensionesPermitidas = ['pdf'];
        $directorio = '../documentos/';
        $carpetaPublica = 'documentos/';
        $mensajeError = 'Solo se permiten archivos PDF';
        break;
}

// Verificar tipo de archivo
if (!in_array($tipoArchivo, $tiposPermitidos) && !in_array($extension, $extensionesPermitidas)) {
    echo json_encode(['success' => false, 'message' => $mensajeError]);
    exit;
}

// Crear directorio si no existe
if (!is_dir($directorio)) {
    mkdir($directorio, 0755, true);
}

// Mantener el nombre original del archivo
$nombreOriginal = $archivo['name'];
$extension = pathinfo($nombreOriginal, PATHINFO_EXTENSION);
$nombreSinExtension = pathinfo($nombreOriginal, PATHINFO_FILENAME);

// Verificar si el archivo ya existe y agregar un sufijo si es necesario
$nombreArchivo = $nombreOriginal;
$contador = 1;
while (file_exists($directorio . $nombreArchivo)) {
    $nombreArchivo = $nombreSinExtension . '_' . $contador . '.' . $extension;
    $contador++;
}

$rutaCompleta = $directorio . $nombreArchivo;

// Mover el archivo subido
if (move_uploaded_file($archivo['tmp_name'], $rutaCompleta)) {
    echo json_encode([
        'success' => true, 
        'message' => 'Archivo subido correctamente',
        'nombreArchivo' => $nombreArchivo,
        'ruta' => $carpetaPublica . $nombreArchivo,
        'tipo' => $tipoSeccion
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al subir el archivo']);
}
?>
