<?php
session_start();
header('Content-Type: application/json');

require_once '../config.php';
require_once '../conexion.php';

try {
    // Obtener parámetros
    $variable = isset($_GET['variable']) ? $_GET['variable'] : '';
    
    if (empty($variable)) {
        throw new Exception('Variable requerida');
    }
    
    // Obtener el curso y unidad de la sesión o parámetros
    $curso = isset($_GET['curso']) ? $_GET['curso'] : '';
    $unidad = isset($_GET['unidad']) ? $_GET['unidad'] : '';
    
    if (empty($curso) || empty($unidad)) {
        throw new Exception('Curso y unidad requeridos');
    }
    
    // Normalizar unidad (convertir "Unidad 01" a "01")
    if (preg_match('/Unidad (\d+)/i', $unidad, $matches)) {
        $unidad = str_pad($matches[1], 2, '0', STR_PAD_LEFT);
    } else {
        $unidad = str_pad($unidad, 2, '0', STR_PAD_LEFT);
    }
    
    // Construir el nombre de la tabla
    $nombre_tabla = 'avance_' . $curso . '_u' . $unidad;
    
    // Obtener el ID del usuario actual (usar session_id si no hay id)
    $usuario_id = $_SESSION['id'] ?? $_SESSION['session_id'] ?? null;
    if (!$usuario_id) {
        throw new Exception('Usuario no autenticado');
    }
    
    // Verificar que la tabla existe
    $stmt = $dsn->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = :tabla");
    $stmt->bindParam(':tabla', $nombre_tabla, PDO::PARAM_STR);
    $stmt->execute();
    $existe = $stmt->fetchColumn();
    
    if (!$existe) {
        throw new Exception('La tabla no existe');
    }
    
    // Obtener el valor de la variable
    $sql = "SELECT `{$variable}` FROM `{$nombre_tabla}` WHERE id = :usuario_id";
    $stmt = $dsn->prepare($sql);
    $stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($resultado === false) {
        throw new Exception('Usuario no encontrado en la tabla');
    }
    
    $valor = $resultado[$variable];
    
    echo json_encode([
        'success' => true,
        'valor' => $valor,
        'variable' => $variable,
        'usuario_id' => $usuario_id
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
