<?php
session_start();
header('Content-Type: application/json');

require_once '../config.php';
require_once '../conexion.php';

try {
    // Obtener datos del POST
    $input = json_decode(file_get_contents('php://input'), true);
    
    $variable = $input['variable'] ?? '';
    $tabla = $input['tabla'] ?? '';
    
    error_log("DEBUG - verificar_condicion_interna.php - Variable: $variable, Tabla: $tabla");
    
    if (empty($variable) || empty($tabla)) {
        throw new Exception('Variable y tabla requeridas');
    }
    
    // Obtener el ID del usuario actual
    $usuario_id = $_SESSION['id'] ?? $_SESSION['session_id'] ?? null;
    error_log("DEBUG - Usuario ID: $usuario_id");
    
    if (!$usuario_id) {
        throw new Exception('Usuario no autenticado');
    }
    
    // Obtener el valor de la variable
    $sql = "SELECT `{$variable}` FROM `{$tabla}` WHERE id = :usuario_id";
    error_log("DEBUG - SQL: $sql");
    $stmt = $dsn->prepare($sql);
    $stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    
    error_log("DEBUG - Resultado de la consulta: " . print_r($resultado, true));
    
    if ($resultado === false) {
        throw new Exception('Usuario no encontrado en la tabla');
    }
    
    $valor = $resultado[$variable];
    error_log("DEBUG - Valor de $variable: $valor");
    
    echo json_encode([
        'success' => true,
        'valor' => $valor,
        'variable' => $variable,
        'tabla' => $tabla,
        'usuario_id' => $usuario_id
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
