<?php
// Archivo para guardar el contenido PHP como config.php

// Verificar que sea una petición POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo 'error: Método no permitido';
    exit;
}

// Verificar que se haya enviado el contenido PHP
if (!isset($_POST['phpContent']) || empty($_POST['phpContent'])) {
    http_response_code(400);
    echo 'error: No se recibió contenido PHP';
    exit;
}

// Obtener el contenido PHP
$phpContent = $_POST['phpContent'];

// Validar que el contenido no esté vacío
if (trim($phpContent) === '') {
    http_response_code(400);
    echo 'error: El contenido PHP está vacío';
    exit;
}

// Intentar guardar el archivo
try {
    $filePath = '../config.php';
    $result = file_put_contents($filePath, $phpContent);
    
    if ($result === false) {
        http_response_code(500);
        echo 'error: No se pudo guardar el archivo en ' . $filePath . '. Verifica los permisos de escritura.';
        exit;
    }
    
    // Éxito
    echo 'success: Archivo config.php guardado exitosamente en ' . $filePath;
    
} catch (Exception $e) {
    http_response_code(500);
    echo 'error: Error al guardar el archivo: ' . $e->getMessage();
    exit;
}
?> 