<?php
// Configurar headers para CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// Verificar que sea una petición POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo 'Método no permitido';
    exit();
}

// Obtener el contenido PHP del POST
$phpContent = $_POST['phpContent'] ?? '';

if (empty($phpContent)) {
    http_response_code(400);
    echo 'Error: No se recibió contenido PHP';
    exit();
}

// Ruta del archivo a guardar
$filePath = '../configuracion_cursos.php';

// Intentar guardar el archivo
try {
    $result = file_put_contents($filePath, $phpContent);
    
    if ($result === false) {
        throw new Exception('No se pudo escribir el archivo');
    }
    
    // Verificar que el archivo se guardó correctamente
    if (!file_exists($filePath)) {
        throw new Exception('El archivo no se creó correctamente');
    }
    
    // Verificar que el contenido se guardó
    $savedContent = file_get_contents($filePath);
    if ($savedContent !== $phpContent) {
        throw new Exception('El contenido guardado no coincide con el enviado');
    }
    
    echo 'success: Archivo configuracion_cursos.php guardado correctamente';
    
} catch (Exception $e) {
    http_response_code(500);
    echo 'Error al guardar el archivo: ' . $e->getMessage();
}
?> 