<?php
/**
 * Guarda el archivo header.css generado
 */

// Verificar que se haya enviado contenido
if (!isset($_POST['cssContent']) || empty($_POST['cssContent'])) {
    http_response_code(400);
    echo "Error: No se recibió contenido para guardar";
    exit;
}

$cssContent = $_POST['cssContent'];

try {
    // Guardar el archivo en la carpeta padre (directorio raíz)
    $filePath = '../header.css';
    
    if (file_put_contents($filePath, $cssContent) !== false) {
        echo "success: Archivo header.css guardado exitosamente en " . $filePath;
    } else {
        throw new Exception("No se pudo escribir el archivo");
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo "Error al guardar el archivo: " . $e->getMessage();
    error_log("Error en guardar_header_css.php: " . $e->getMessage());
}
?>