<?php
/**
 * Guardador del archivo lectura_inscripcion_cursos.php
 * Guarda el contenido generado en el archivo lectura_inscripcion_cursos.php
 */

// Verificar que se recibió el contenido
if (!isset($_POST['phpContent']) || empty($_POST['phpContent'])) {
    echo "Error: No se recibió contenido PHP para guardar";
    exit;
}

$phpContent = $_POST['phpContent'];

// Ruta donde guardar el archivo
$archivo = '../lectura_inscripcion_cursos.php';

// Crear backup del archivo existente si existe
if (file_exists($archivo)) {
    $backup = $archivo . '.backup.' . date('Y-m-d_H-i-s');
    if (!copy($archivo, $backup)) {
        echo "Error: No se pudo crear backup del archivo existente";
        exit;
    }
}

// Intentar guardar el archivo
$resultado = file_put_contents($archivo, $phpContent);

if ($resultado === false) {
    echo "Error: No se pudo guardar el archivo lectura_inscripcion_cursos.php";
    exit;
}

// Verificar que el archivo se guardó correctamente
if (!file_exists($archivo)) {
    echo "Error: El archivo no se creó correctamente";
    exit;
}

// Obtener información del archivo guardado
$tamano = filesize($archivo);
$modificado = date('Y-m-d H:i:s', filemtime($archivo));

// Respuesta de éxito
echo "success: Archivo lectura_inscripcion_cursos.php guardado exitosamente\n";
echo "Tamaño: $tamano bytes\n";
echo "Modificado: $modificado\n";

if (isset($backup)) {
    echo "Backup creado: " . basename($backup) . "\n";
}
?> 