<?php
// Archivo para guardar el contenido HTML como login.html

// Verificar que sea una petición POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo 'error: Método no permitido';
    exit;
}

// Verificar que se haya enviado el contenido HTML
if (!isset($_POST['htmlContent']) || empty($_POST['htmlContent'])) {
    http_response_code(400);
    echo 'error: No se recibió contenido HTML';
    exit;
}

// Obtener el contenido HTML
$htmlContent = $_POST['htmlContent'];

// Validar que el contenido no esté vacío
if (trim($htmlContent) === '') {
    http_response_code(400);
    echo 'error: El contenido HTML está vacío';
    exit;
}

// Intentar guardar el archivo
try {
    $filePath = '../login.html';
    $result = file_put_contents($filePath, $htmlContent);
    
    if ($result === false) {
        http_response_code(500);
        echo 'error: No se pudo guardar el archivo en ' . $filePath . '. Verifica los permisos de escritura.';
        exit;
    }
    
    // Éxito
    echo 'success: Archivo login.html guardado exitosamente en ' . $filePath;
    
} catch (Exception $e) {
    http_response_code(500);
    echo 'error: Error al guardar el archivo: ' . $e->getMessage();
    exit;
}
?> 