<?php
/**
 * Lector del archivo config.php
 * Lee la configuración de base de datos de manera segura
 */

// Configurar headers para evitar cache
header('Content-Type: text/plain; charset=utf-8');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

// Ruta al archivo config.php
$archivo = '../config.php';

// Verificar si el archivo existe
if (!file_exists($archivo)) {
    http_response_code(404);
    echo "<!-- DEBUG: Archivo no encontrado -->\n";
    echo "El archivo config.php no existe en la ubicación esperada.";
    exit;
}

// Leer el contenido del archivo
$contenido = file_get_contents($archivo);

if ($contenido === false) {
    http_response_code(500);
    echo "<!-- DEBUG: Error al leer archivo -->\n";
    echo "Error al leer el archivo config.php";
    exit;
}

// Obtener información del archivo
$tamano = filesize($archivo);
$modificado = date('Y-m-d H:i:s', filemtime($archivo));

// Agregar información de debug
echo "<!-- DEBUG: Archivo encontrado, tamaño: $tamano bytes, modificado: $modificado -->\n";

// Devolver el contenido del archivo
echo $contenido;
?> 