<?php
// Configurar headers para CORS y anti-cache
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET');
header('Content-Type: text/plain; charset=utf-8');
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

// Limpiar cualquier output buffer
if (ob_get_level()) {
    ob_clean();
}

// Ruta del archivo a leer
$filePath = '../configuracion_cursos.php';

// Verificar si el archivo existe
if (file_exists($filePath)) {
    // Obtener información del archivo
    $fileSize = filesize($filePath);
    $lastModified = filemtime($filePath);
    
    // Leer el contenido del archivo
    $content = file_get_contents($filePath);
    
    if ($content !== false) {
        // Agregar información de debug al inicio (comentado)
        $debug = "<!-- DEBUG: Archivo encontrado, tamaño: {$fileSize} bytes, modificado: " . date('Y-m-d H:i:s', $lastModified) . " -->\n";
        echo $debug . $content;
    } else {
        http_response_code(500);
        echo 'Error: No se pudo leer el archivo configuracion_cursos.php';
    }
} else {
    http_response_code(404);
    echo 'Archivo configuracion_cursos.php no encontrado en: ' . realpath(dirname(__FILE__) . '/../');
}
?> 