<?php
// Configurar headers para CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Type: application/json');

// Verificar que sea una petición POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Método no permitido']);
    exit();
}

// Obtener los datos del POST
$codigoAnterior = $_POST['codigoAnterior'] ?? '';
$codigoNuevo = $_POST['codigoNuevo'] ?? '';

if (empty($codigoAnterior) || empty($codigoNuevo)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Faltan códigos requeridos']);
    exit();
}

try {
    $directorioImagenes = '../imagenes_cursos/';
    $archivoAnterior = $directorioImagenes . 'img_' . $codigoAnterior . '.jpg';
    $archivoNuevo = $directorioImagenes . 'img_' . $codigoNuevo . '.jpg';
    
    // Verificar si existe la imagen anterior
    if (!file_exists($archivoAnterior)) {
        echo json_encode([
            'success' => true,
            'mensaje' => 'No había imagen para renombrar',
            'nuevaRuta' => ''
        ]);
        exit();
    }
    
    // Renombrar el archivo
    if (rename($archivoAnterior, $archivoNuevo)) {
        $nuevaRuta = 'imagenes_cursos/img_' . $codigoNuevo . '.jpg';
        echo json_encode([
            'success' => true,
            'mensaje' => 'Imagen renombrada correctamente',
            'nuevaRuta' => $nuevaRuta
        ]);
    } else {
        throw new Exception('No se pudo renombrar la imagen');
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?> 